/**
 * 
 */
package gov.va.med.mhv.liferay.saml.binding.impl;

import org.apache.velocity.app.VelocityEngine;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.xml.parse.ParserPool;

import com.liferay.saml.binding.impl.HttpPostBinding;

import gov.va.med.mhv.liferay.saml.binding.decoding.MhvCustomURIComparator;

/**
 * @author vhaislegberb
 *
 */
public class MhvHttpPostBinding extends HttpPostBinding {

	public MhvHttpPostBinding(ParserPool parserPool, VelocityEngine velocityEngine) {
		super(parserPool, velocityEngine);
		
		// override URI comparator 
		HTTPPostDecoder messageDecoder = (HTTPPostDecoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(new MhvCustomURIComparator());
	}
	
	public MhvHttpPostBinding(ParserPool parserPool, VelocityEngine velocityEngine, URIComparator uriComparator) {
		super(parserPool, velocityEngine);
		
		// override URI comparator 
		HTTPPostDecoder messageDecoder = (HTTPPostDecoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(uriComparator);
	}
}
